# Player Config ID: huggingface_DeepSeek-V3-0324_DeceptiveAgent_A (as Player A)
# Meta-Round: 7
# Experiment: DAxDA, Run: 5
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek-V3-0324_DeceptiveAgent_A_MR7_strategy.txt
# LLM Suggested Fallback: D

def gentle_butterfly_whisperer_v2(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    # Initialize a trust score (actually tracks defections)
    trust_score = sum(1 for x in opp_history if x == "D") if opp_history else 0
    
    # Round 1: Build trust
    if not my_history:
        return "C"
    
    # Round 2: Test opponent's reaction
    if len(my_history) == 1:
        return "D"
    
    # Round 3: Feign reconciliation
    if len(my_history) == 2:
        return "C"
    
    # Mid-Game Exploitation (Rounds 4-7)
    if 3 <= len(my_history) < 7:
        if opp_history[-1] == "C":
            return "D"  # Exploit their cooperation
        else:
            return "C"  # Confuse them
    
    # Late-Game Aggression (Rounds 8-10)
    if len(my_history) >= 7:
        if trust_score / len(opp_history) < 0.4:  # Mostly cooperative
            return "D"
        else:  # Mostly retaliatory
            return "D" if len(my_history) % 2 == 0 else "C"
    
    # Fallback (should not reach here)
    return "D"